import {IElementRect} from '../../interfaces/lib/dimensions/IElementRect';

import intersectRects from './intersectRects';

interface IGetPopupIntersectionAreaArgs {
    windowRect: IElementRect;
    rootRect: IElementRect;
    popupRect: IElementRect;
}

export default function getPopupIntersectionArea({
    windowRect,
    rootRect,
    popupRect,
}: IGetPopupIntersectionAreaArgs): number {
    // Если попап уходит за левый или верхний край, то это очень плохая позиция,
    // т.к. попап нельзя будет увидеть целиком
    if (popupRect.top < rootRect.top || popupRect.left < rootRect.left) {
        return -Infinity;
    }

    // Если попап уходит за правый или нижний край, то это тоже не очень хорошая позиция
    // т.к. появится лишний скролл
    if (
        popupRect.bottom > rootRect.bottom ||
        popupRect.right > rootRect.right
    ) {
        return -1000;
    }

    const intersectionRect = intersectRects(windowRect, popupRect);

    return intersectionRect.width * intersectionRect.height;
}
