import SecondaryPosition from '../../interfaces/lib/dimensions/SecondaryPosition';

import {IElementRect} from '../../interfaces/lib/dimensions/IElementRect';
import PrimaryPosition from '../../interfaces/lib/dimensions/PrimaryPosition';

interface IGetPopupRectArgs {
    parentRect: IElementRect;
    dimensions: DOMRect;
    position: [PrimaryPosition, SecondaryPosition];
}

export default function getPopupRect({
    parentRect,
    dimensions,
    position,
}: IGetPopupRectArgs): IElementRect {
    const {width, height} = dimensions;

    const [primary, secondary] = position;

    const offset = 10;

    let bottom = Infinity;
    let top = Infinity;
    let left = Infinity;
    let right = Infinity;

    switch (primary) {
        case PrimaryPosition.top:
            bottom = parentRect.top - offset;
            top = bottom - height;
            break;
        case PrimaryPosition.left:
            right = parentRect.left - offset;
            left = right - width;
            break;
        case PrimaryPosition.right:
            left = parentRect.right + offset;
            right = left + width;
            break;
        case PrimaryPosition.bottom:
            top = parentRect.bottom + offset;
            bottom = top + height;
            break;
    }

    switch (secondary) {
        case SecondaryPosition.top:
            bottom = parentRect.bottom;
            top = bottom - height;
            break;
        case SecondaryPosition.left:
            left = parentRect.left;
            right = parentRect.left + width;
            break;
        case SecondaryPosition.right:
            right = parentRect.right;
            left = parentRect.right - width;
            break;
        case SecondaryPosition.bottom:
            top = parentRect.top;
            bottom = parentRect.top + height;
            break;
        case SecondaryPosition.center:
            if (
                primary === PrimaryPosition.top ||
                primary === PrimaryPosition.bottom
            ) {
                left = parentRect.left + (parentRect.width - width) / 2;
                right = left + width;
            } else {
                top =
                    parentRect.top +
                    (parentRect.height - dimensions.height) / 2;
                bottom = top + height;
            }

            break;
    }

    if ([top, bottom, left, right].some(side => side === Infinity)) {
        throw new Error(
            'Одна из сторон не была определена в ходе получения PopupRect',
        );
    }

    return {
        width,
        height,
        top,
        bottom,
        left,
        right,
    };
}
