import {FIXED_ELEMENT_CLASS_NAME} from '../../components/_constants/fixedElementClassName';

import {IElementRect} from '../../interfaces/lib/dimensions/IElementRect';

import getElementRect from './getElementRect';

export default function getRootRect(): IElementRect {
    const rootRect = getElementRect(document.querySelector('.Root'));
    // Чтобы корректно определять позицию попапов, мы находим fixed элементы
    // на странице и учитываем их при вычислении размеров рута
    // Из-за этого элементы со стилем display: fixed обязаны иметь
    // класс FIXED_ELEMENT_CLASS_NAME
    const fixedBlocks = [
        ...document.getElementsByClassName(FIXED_ELEMENT_CLASS_NAME),
    ];

    const limiter = fixedBlocks.reduce(
        (result, fixedBlock) => {
            const blockRect = fixedBlock.getBoundingClientRect();

            // Считаем, что у нас есть два вида фиксированных блоков: сверху и снизу
            if (blockRect.top === 0) {
                result.topOffset = Math.max(blockRect.height, result.topOffset);
            }

            if (
                Math.round(blockRect.bottom) === Math.round(window.innerHeight)
            ) {
                result.bottomOffset = Math.max(
                    blockRect.height,
                    result.bottomOffset,
                );
            }

            return result;
        },
        {
            topOffset: 0,
            bottomOffset: 0,
        },
    );

    return {
        width: rootRect.width,
        height: rootRect.height - limiter.topOffset - limiter.bottomOffset,
        top: limiter.topOffset,
        bottom: rootRect.bottom - limiter.bottomOffset,
        left: rootRect.left,
        right: rootRect.right,
    };
}
