import {IElementRect} from '../../interfaces/lib/dimensions/IElementRect';

export default function getWindowRect(): IElementRect {
    const {
        pageYOffset: top,
        pageXOffset: left,
        innerWidth: width,
        innerHeight: height,
    } = window;

    return {
        top,
        left,
        right: left + width,
        bottom: top + height,
        width,
        height,
    };
}
