import {IElementRect} from '../../interfaces/lib/dimensions/IElementRect';

export default function intersectRects(
    rectA: IElementRect,
    rectB: IElementRect,
): IElementRect {
    const top = Math.max(rectA.top, rectB.top);
    const left = Math.max(rectA.left, rectB.left);
    const right = Math.min(rectA.right, rectB.right);
    const bottom = Math.min(rectA.bottom, rectB.bottom);

    return {
        top,
        left,
        right,
        bottom,
        width: Math.max(right - left, 0),
        height: Math.max(bottom - top, 0),
    };
}
