import SecondaryPosition from '../../interfaces/lib/dimensions/SecondaryPosition';
import PrimaryPosition from '../../interfaces/lib/dimensions/PrimaryPosition';
import {IElementRect} from '../../interfaces/lib/dimensions/IElementRect';

import getPopupRect from './getPopupRect';
import getPopupIntersectionArea from './getPopupIntersectionArea';

const PRECISION = 0.001;

interface ISelectPopupPositionArgs {
    rootRect: IElementRect;
    windowRect: IElementRect;
    parentRect: IElementRect;
    dimensions: DOMRect;
    positions: [PrimaryPosition, SecondaryPosition][];
}

export default function selectPopupPosition({
    rootRect,
    windowRect,
    parentRect,
    dimensions,
    positions,
}: ISelectPopupPositionArgs): [PrimaryPosition, SecondaryPosition] {
    let bestPosition: [PrimaryPosition, SecondaryPosition] | null = null;
    let bestIntersectionArea = 0;

    const maxIntersectionArea = dimensions.width * dimensions.height;

    for (let i = 0; i < positions.length; i++) {
        const position = positions[i];
        const popupRect = getPopupRect({parentRect, dimensions, position});
        const intersectionArea = getPopupIntersectionArea({
            rootRect,
            windowRect,
            popupRect,
        });

        if (Math.abs(intersectionArea - maxIntersectionArea) < PRECISION) {
            return position;
        }

        if (!bestPosition || intersectionArea > bestIntersectionArea) {
            bestPosition = position;
            bestIntersectionArea = intersectionArea;
        }
    }

    return bestPosition || positions[0];
}
