import {TRAIN_TYPE} from '../transportType';
import {RU, BY, UA, KZ, UZ} from '../countries';

const OUR_COUNTRIES = new Set([RU, BY, UA, KZ, UZ]);

export function trainIncompleteScheduleDisclaimerIsAvailable(
    {from, to},
    segments,
) {
    const countryFrom = from && from.country && from.country.code;
    const countryTo = to && to.country && to.country.code;
    const trainInSegments = segments.some(
        ({transport}) => transport && transport.code === TRAIN_TYPE,
    );

    return (
        trainInSegments &&
        !OUR_COUNTRIES.has(countryFrom) &&
        !OUR_COUNTRIES.has(countryTo)
    );
}

export function belarusSearchDisclaimerIsAvailable({from, to}, tld) {
    const countryFrom = from && from.country && from.country.code;
    const countryTo = to && to.country && to.country.code;

    return tld === 'by' && countryFrom === BY && countryTo === BY;
}
