import {getNumericStyle} from './style';

export function getDimension(element, dimension, include) {
    const {dim, sides} = {
        width: {
            dim: 'Width',
            sides: ['left', 'right'],
        },
        height: {
            dim: 'Height',
            sides: ['top', 'bottom'],
        },
    }[dimension];

    switch (include) {
        case 'padding':
            return element[`client${dim}`];
        case 'border':
            return element[`offset${dim}`];
        case 'margin': {
            const style = getNumericStyle(element);

            return (
                element[`offset${dim}`] +
                style(`margin-${sides[0]}`) +
                style(`margin-${sides[1]}`)
            );
        }

        default: {
            const style = getNumericStyle(element);

            return (
                element[`client${dim}`] -
                style(`padding-${sides[0]}`) -
                style(`padding-${sides[1]}`)
            );
        }
    }
}

export function getHeight(element, include) {
    return getDimension(element, 'height', include);
}

export function getWidth(element, include) {
    return getDimension(element, 'width', include);
}
