import Enum from '../../interfaces/Enum';

// Возвращает типизированное значение из переданного enum, если оно в нем есть или undefined
// Применяется для того, чтобы понять, что строка/число принадлежит нужному enum
export default function getArrayValuesFromEnum<T extends Enum<T>>(
    values: string[],
    enumInstance: T,
): T[keyof T][] {
    const valuesInEnum = Object.entries(enumInstance)
        // Убираем числовые ключи, потому что зачем-то числовой enum добавляет обратное сочетание {"значение": "ключ"} в объект с enum
        .filter(([key]) => isNaN(parseInt(key, 10)))
        .map(([, enumValue]) => enumValue);

    return values.filter(value => valuesInEnum.includes(value)) as T[keyof T][];
}
