export const ERROR_TYPES = {
    SEARCH_FORM: 'searchForm',
    AMBIGUOUS: 'ambiguous',
    COMMON: 'error',
    SEARCH_NEXT_DEFAULT_DIRECTION_NOT_FOUND:
        'nearest_default_direction_not_found',
    NO_ROUTES: 'no_routes',
    SETTLEMENT_NOT_FOUND: 'settlement_not_found',
    STATION_WITH_NO_MAIN_TYPE_AND_SUBTYPES:
        'station_with_no_main_type_and_subtypes',
};

const ERROR_WEIGHTS = {
    [ERROR_TYPES.AMBIGUOUS]: 1,
    [ERROR_TYPES.SEARCH_FORM]: 0,
    [ERROR_TYPES.COMMON]: 0,
    [ERROR_TYPES.SEARCH_NEXT_DEFAULT_DIRECTION_NOT_FOUND]: 1,
    [ERROR_TYPES.NO_ROUTES]: 1,
};

const ERRORS = new Set([
    ERROR_TYPES.AMBIGUOUS,
    ERROR_TYPES.SEARCH_NEXT_DEFAULT_DIRECTION_NOT_FOUND,
    ERROR_TYPES.NO_ROUTES,
]);

/**
 * Объект ошибки при разборе формы
 * Логика this.type такова - по умолчанию код ошибки SEARCH_FORM, если среди переданных кодов есть самостоятельный, то возьмется его код
 * @param {string} message сообщение ошибки
 * @param {string[]} errorTypes ошибки
 * @constructor
 */
export function ParseError(message, errorTypes = []) {
    this.message = message;
    this.type = errorTypes.reduce(
        (result, type) =>
            ERRORS.has(type) && ERROR_WEIGHTS[type] > ERROR_WEIGHTS[result]
                ? type
                : result,
        ERROR_TYPES.SEARCH_FORM,
    );
}

ParseError.prototype = Object.create(Error.prototype);
