import get from 'lodash/get';
import sortBy from 'lodash/sortBy';

export function prepareAmbiguousErrors(errors) {
    const path = 'ambiguousTitle.additionalTitle';

    return sortBy(errors, o => get(o, path) || '')
        .map(item => ({
            ...item,
            ambiguousTitle: {
                ...item.ambiguousTitle,
                title: [
                    {
                        name: item.ambiguousTitle.title,
                        key: item.key,
                        slug: item.slug,
                    },
                ],
            },
        }))
        .reduce((result, item) => {
            const lastItem = result[result.length - 1] || {};

            if (get(item, path) === get(lastItem, path)) {
                lastItem.ambiguousTitle.title = [
                    ...lastItem.ambiguousTitle.title,
                    ...item.ambiguousTitle.title,
                ];
            } else {
                result.push(item);
            }

            return result;
        }, []);
}
