import {ALL_TYPE, SUBURBAN_TYPE} from '../transportType';

import baseManager from './baseFilterManager';

const suburbanTypes = [
    {
        value: 'aeroexpress',
        queryValue: 'y',
    },
    {
        value: 'general',
        queryValue: 'n',
    },
];

function getSuburbanType(segment) {
    const {transport = {}, thread = {}} = segment;

    if (!transport || transport.code !== SUBURBAN_TYPE) {
        return null;
    }

    return thread.isAeroExpress ? suburbanTypes[0] : suburbanTypes[1];
}

export default {
    ...baseManager,

    type: 'aeroexpress',
    supportedFor: new Set([ALL_TYPE, SUBURBAN_TYPE]),

    apply(value, segment) {
        const suburbanType = getSuburbanType(segment);

        return suburbanType ? value.includes(suburbanType.value) : false;
    },

    updateOptions(options, segment) {
        const suburbanType = getSuburbanType(segment);

        if (!suburbanType || options.includes(suburbanType.value)) {
            return options;
        }

        return suburbanTypes
            .map(type => type.value)
            .filter(
                value =>
                    value === suburbanType.value || options.includes(value),
            );
    },

    serializeToQuery(value) {
        const queryValue = suburbanTypes
            .filter(type => value.includes(type.value))
            .map(type => type.queryValue);

        return {aeroex: queryValue};
    },

    deserializeFromQuery({aeroex}) {
        if (!aeroex) {
            return this.getDefaultValue();
        }

        if (!Array.isArray(aeroex)) {
            aeroex = [aeroex];
        }

        return suburbanTypes
            .filter(type => aeroex.includes(type.queryValue))
            .map(type => type.value);
    },

    isAvailableForContext(context) {
        return this.supportedFor.has(context.transportType);
    },

    isAvailableWithOptions(options) {
        return options.length > 1;
    },

    validateValue(value = [], options = []) {
        return value.filter(item => options.includes(item));
    },
};
