import {TIMES_OF_DAY_LIST} from '../date/values';

import timeOfDay from './timeOfDay';
import {getTimeOfDay, getIntervalTimesOfDay} from '../date/utils';
import {getLocalArrivalTime} from '../segments/cachedSegmentTime';

export default {
    ...timeOfDay,

    type: 'arrival',

    apply(value = [], segment) {
        if (!value.length) {
            return true;
        }

        if (segment.isInterval) {
            const intervalTimes = getIntervalTimesOfDay(segment);

            return intervalTimes.some(time => value.includes(time));
        }

        const arrivalTime = getTimeOfDay(getLocalArrivalTime(segment).hour());

        return value.includes(arrivalTime);
    },

    updateOptions(options, segment) {
        // небольшая оптимизация, т.к. дальнейшие вызовы функции не изменят опции фильтра
        if (options.length === TIMES_OF_DAY_LIST.length) {
            return options;
        }

        if (segment.isInterval) {
            getIntervalTimesOfDay(segment).forEach(time => {
                if (!options.includes(time)) {
                    options.push(time);
                }
            });
        } else {
            const time = getTimeOfDay(getLocalArrivalTime(segment).hour());

            if (!options.includes(time)) {
                options.push(time);
            }
        }

        return options;
    },

    serializeToQuery(arrival) {
        return arrival.length ? {arrival} : {};
    },

    deserializeFromQuery({arrival}) {
        if (!Array.isArray(arrival)) {
            arrival = [arrival];
        }

        const departureIsValid = arrival.every(item =>
            TIMES_OF_DAY_LIST.includes(item),
        );

        return departureIsValid ? arrival : [];
    },
};
