import {ALL_TYPE} from '../transportType';
import baseManager from './baseFilterManager';

function getCarrierId(segment) {
    return segment.company ? `${segment.company.id}` : null;
}

export default {
    ...baseManager,

    type: 'carriers',

    apply(value, segment) {
        const carrierId = getCarrierId(segment);

        if (!carrierId) {
            return false;
        }

        return value.includes(carrierId);
    },

    updateOptions(options, segment) {
        const carrierId = getCarrierId(segment);

        if (
            !carrierId ||
            segment.transport.code !== 'plane' ||
            options.some(option => option.id === carrierId)
        ) {
            return options;
        }

        return [
            ...options,
            {
                id: carrierId,
                title: segment.company.title,
            },
        ];
    },

    serializeToQuery(value) {
        return {carrier: value};
    },

    deserializeFromQuery({carrier}) {
        if (!carrier) {
            return this.getDefaultValue();
        }

        return Array.isArray(carrier) ? carrier : [carrier];
    },

    isAvailableForContext(context) {
        return (
            context.transportType === ALL_TYPE ||
            context.transportType === 'plane'
        );
    },

    isAvailableWithOptions(options) {
        return options.length > 1;
    },

    validateValue(value = [], options = []) {
        const carrierIds = options.map(({id}) => id);

        return value.filter(item => carrierIds.includes(item));
    },
};
