import {TIMES_OF_DAY_LIST} from '../date/values';

import timeOfDay from './timeOfDay';
import {getTimeOfDay, getIntervalTimesOfDay} from '../date/utils';
import {getLocalDepartureTime} from '../segments/cachedSegmentTime';

export default {
    ...timeOfDay,

    type: 'departure',

    apply(value = [], segment) {
        if (!value.length) {
            return true;
        }

        if (segment.isInterval) {
            const intervalTimes = getIntervalTimesOfDay(segment);

            return intervalTimes.some(time => value.includes(time));
        }

        const departureTime = getTimeOfDay(
            getLocalDepartureTime(segment).hour(),
        );

        return value.includes(departureTime);
    },

    updateOptions(options, segment) {
        // небольшая оптимизация, т.к. дальнейшие вызовы функции не изменят опции фильтра
        if (options.length === TIMES_OF_DAY_LIST.length) {
            return options;
        }

        if (segment.isInterval) {
            getIntervalTimesOfDay(segment).forEach(time => {
                if (!options.includes(time)) {
                    options.push(time);
                }
            });
        } else {
            const time = getTimeOfDay(getLocalDepartureTime(segment).hour());

            if (!options.includes(time)) {
                options.push(time);
            }
        }

        return options;
    },

    serializeToQuery(departure) {
        return departure.length ? {departure} : {};
    },

    deserializeFromQuery({departure}) {
        if (!Array.isArray(departure)) {
            departure = [departure];
        }

        const departureIsValid = departure.every(item =>
            TIMES_OF_DAY_LIST.includes(item),
        );

        return departureIsValid ? departure : [];
    },
};
