import {FilterTransportType} from '../transportType';

import baseManager from './baseFilterManager';

function segmentHasExpress(segment) {
    return Boolean(segment.thread && segment.thread.isExpress);
}

export default {
    ...baseManager,

    type: 'express',

    supportedFor: new Set([
        FilterTransportType.all,
        FilterTransportType.suburban,
    ]),

    getDefaultValue() {
        return false;
    },

    getDefaultOptions() {
        return {withExpress: false, withoutExpress: false};
    },

    apply(value, segment) {
        return !value || segmentHasExpress(segment);
    },

    updateOptions(options, segment) {
        if (options.withExpress && options.withoutExpress) {
            return options;
        }

        if (segmentHasExpress(segment)) {
            return {
                ...options,
                withExpress: true,
            };
        }

        return {
            ...options,
            withoutExpress: true,
        };
    },

    serializeToQuery(expressOnly) {
        return expressOnly ? {express: 'y'} : {};
    },

    deserializeFromQuery({express}) {
        return typeof express === 'string' && express.toLowerCase() === 'y';
    },

    isDefaultValue(expressOnly) {
        return expressOnly === this.getDefaultValue();
    },

    isAvailableForContext(context) {
        return this.supportedFor.has(context.transportType);
    },

    isAvailableWithOptions(options) {
        return options.withExpress;
    },
};
