import {momentTimezone as moment} from '../../../reexports';

import DateSpecialValue from '../../interfaces/date/DateSpecialValue';

import baseManager from './baseFilterManager';

export const GONE_FILTER_TYPE = 'gone';

export default {
    ...baseManager,
    type: GONE_FILTER_TYPE,
    skipIfReset: true,
    availableWithOptions: true,
    apply(value, segment) {
        return value || !segment.isGone;
    },
    updateOptions(options, segment) {
        return {
            isGone: options.isGone + Number(segment.isGone, 10),
            isNotGoneYet: options.isNotGoneYet + Number(!segment.isGone, 10),
        };
    },
    isAvailableForContext(context) {
        if (context.when.special === DateSpecialValue.allDays) {
            return false;
        }

        const contextDate = moment.tz(context.when.date, context.time.timezone);
        const today = moment.tz(context.time.now, context.time.timezone);
        const yesterday = today.clone().subtract(1, 'day');

        return (
            today.isSame(contextDate, 'day') ||
            yesterday.isSame(contextDate, 'day')
        );
    },
    isAvailableWithActiveOptions(options) {
        return Boolean(options.isGone && options.isNotGoneYet);
    },
    isAvailableWithOptions(options) {
        this.availableWithOptions = Boolean(
            options.isGone && options.isNotGoneYet,
        );

        return this.availableWithOptions;
    },
    // Для большинства фильтров установленное дефолтное значение сигнализирует, что фильтрация списка сегментов не требуется
    // В данном случае логика инвертированна: при отключенном фильтре нам необходимо скрывать сегменты, при включенном - показывать
    isDefaultValue(value) {
        return value === this.getDefaultValue();
    },
    shouldApply(value) {
        return this.availableWithOptions && this.isDefaultValue(value);
    },
    serializeToQuery(value) {
        return value ? {gone: 'y'} : {};
    },
    deserializeFromQuery({gone}) {
        return typeof gone === 'string' && gone.toLowerCase() === 'y';
    },
    getDefaultValue() {
        return false;
    },
    getDefaultOptions() {
        return {
            isGone: 0,
            isNotGoneYet: 0,
        };
    },
};
