import {FilterTransportType} from '../transportType';

import baseManager from './baseFilterManager';

function getHighSpeedTrain(segment) {
    const {transport = {}, thread = {}} = segment;
    const isTrain = transport && transport.code === FilterTransportType.train;
    const deluxeTrain = (thread && thread.deluxeTrain) || {};

    return isTrain && deluxeTrain.isHighSpeed
        ? {
              value: `${deluxeTrain.id}`,
              text: deluxeTrain.title,
          }
        : null;
}

export default {
    ...baseManager,

    type: 'highSpeedTrain',
    supportedFor: new Set([FilterTransportType.all, FilterTransportType.train]),

    apply(value, segment) {
        const train = getHighSpeedTrain(segment);

        return train ? value.includes(train.value) : false;
    },

    updateOptions(options, segment) {
        const train = getHighSpeedTrain(segment);

        if (!train || options.find(({value}) => value === train.value)) {
            return options;
        }

        return [...options, train];
    },

    serializeToQuery(value) {
        return value ? {highSpeedTrain: value} : {};
    },

    deserializeFromQuery({highSpeedTrain}) {
        if (!highSpeedTrain) {
            return this.getDefaultValue();
        }

        return Array.isArray(highSpeedTrain)
            ? [...new Set(highSpeedTrain)]
            : [highSpeedTrain];
    },

    isAvailableForContext(context) {
        return this.supportedFor.has(context.transportType);
    },

    isAvailableWithOptions(options) {
        return Boolean(options.length);
    },

    validateValue(value = [], options = []) {
        const trainIds = options.map(item => item.value);

        return value.filter(item => trainIds.includes(item));
    },
};
