import baseManager from './baseFilterManager';

/**
 * Проверяет указана ли у сегмента цена
 * @param {Object} segment
 * @return {boolean}
 */
function segmentHasPrice(segment) {
    return (
        segment.queryingPrices ||
        Boolean(
            segment.tariffs &&
                segment.tariffs.classes &&
                Object.keys(segment.tariffs.classes).length,
        )
    );
}

export default {
    ...baseManager,

    type: 'pricePresence',

    getDefaultValue() {
        return false;
    },

    getDefaultOptions() {
        return {withPrice: false, withoutPrice: false};
    },

    apply(withPriceOnly, segment) {
        return !withPriceOnly || segmentHasPrice(segment);
    },

    updateOptions(options, segment) {
        if (options.withPrice && options.withoutPrice) {
            return options;
        }

        if (segmentHasPrice(segment)) {
            return {
                withPrice: true,
                withoutPrice: options.withoutPrice,
            };
        }

        return {
            withPrice: options.withPrice,
            withoutPrice: true,
        };
    },

    serializeToQuery(withPriceOnly) {
        return {
            seats: withPriceOnly ? 'y' : '',
        };
    },

    deserializeFromQuery({seats}) {
        return typeof seats === 'string' && seats.toLowerCase() === 'y';
    },

    isDefaultValue(withPriceOnly) {
        return withPriceOnly === this.getDefaultValue();
    },

    isAvailableForContext({searchForPastDate}) {
        return !searchForPastDate;
    },

    isAvailableWithOptions(options) {
        return options.withPrice && options.withoutPrice;
    },
};
