import baseManager from './baseFilterManager';

export default {
    ...baseManager,

    type: 'stationFrom',

    apply(value, {stationFrom}) {
        const id = stationFrom && stationFrom.id && stationFrom.id.toString();

        return value.length ? value.includes(id) : true;
    },

    updateOptions(options, {stationFrom}) {
        const fromId =
            stationFrom && stationFrom.id && stationFrom.id.toString();

        if (fromId && !options.find(item => item.value === fromId)) {
            options.push({
                value: fromId,
                text: stationFrom.popularTitle || stationFrom.title,
            });
        }

        return options;
    },

    serializeToQuery(value) {
        if (this.isDefaultValue(value)) {
            return {};
        }

        return {stationFrom: value || []};
    },

    deserializeFromQuery({stationFrom}) {
        if (!stationFrom) {
            return this.getDefaultValue();
        }

        return Array.isArray(stationFrom) ? stationFrom : [stationFrom];
    },

    isAvailableWithOptions(options) {
        return options.length > 1;
    },

    isDefaultValue(value) {
        return (
            Array.isArray(value) &&
            value.length === this.getDefaultValue().length
        );
    },

    validateValue(value = [], options = []) {
        const validValues = new Set(options.map(item => item.value));

        return value.filter(item => validValues.has(item));
    },
};
