import baseManager from './baseFilterManager';

export default {
    ...baseManager,

    type: 'stationTo',

    apply(value, {stationTo}) {
        const id = stationTo && stationTo.id && stationTo.id.toString();

        return value.length ? value.includes(id) : true;
    },

    updateOptions(options, {stationTo}) {
        const toId = stationTo && stationTo.id && stationTo.id.toString();

        if (toId && !options.find(item => item.value === toId)) {
            options.push({
                value: toId,
                text: stationTo.popularTitle || stationTo.title,
            });
        }

        return options;
    },

    serializeToQuery(value) {
        if (this.isDefaultValue(value)) {
            return {};
        }

        return {stationTo: value || []};
    },

    deserializeFromQuery({stationTo}) {
        if (!stationTo) {
            return this.getDefaultValue();
        }

        return Array.isArray(stationTo) ? stationTo : [stationTo];
    },

    isAvailableWithOptions(options) {
        return options.length > 1;
    },

    isDefaultValue(value) {
        return (
            Array.isArray(value) &&
            value.length === this.getDefaultValue().length
        );
    },

    validateValue(value = [], options = []) {
        const validValues = new Set(options.map(item => item.value));

        return value.filter(item => validValues.has(item));
    },
};
