import {TIMES_OF_DAY_LIST} from '../date/values';

import baseManager from './baseFilterManager';

export default {
    ...baseManager,

    type: 'timeOfDay',

    getDefaultValue() {
        return [];
    },

    getDefaultOptions() {
        return [];
    },

    isDefaultValue(options) {
        return !options.length;
    },

    isAvailableForContext() {
        return true;
    },

    isAvailableWithOptions(options) {
        return options.length > 1;
    },

    validateValue(options) {
        return options.filter(item => TIMES_OF_DAY_LIST.includes(item));
    },
};
