import {ALL_TYPE, TRAIN_TYPE} from '../transportType';
import {TRAIN_TARIFF_CLASSES} from '../segments/tariffClasses';
import baseManager from './baseFilterManager';

function getSegmentClasses(segment) {
    return segment.tariffs && segment.tariffs.classes
        ? Object.keys(segment.tariffs.classes)
        : [];
}

export default {
    ...baseManager,

    type: 'trainTariffClass',

    apply(value, segment) {
        return getSegmentClasses(segment).some(tariffClass =>
            value.includes(tariffClass),
        );
    },

    updateOptions(options, segment) {
        const segmentClasses = getSegmentClasses(segment);

        if (
            segmentClasses.every(tariffClass => options.includes(tariffClass))
        ) {
            return options;
        }

        return TRAIN_TARIFF_CLASSES.filter(
            tariffClass =>
                options.includes(tariffClass) ||
                segmentClasses.includes(tariffClass),
        );
    },

    serializeToQuery(value) {
        return {trainTariffClass: value};
    },

    deserializeFromQuery({trainTariffClass}) {
        if (!trainTariffClass) {
            return this.getDefaultValue();
        }

        const queryClasses = Array.isArray(trainTariffClass)
            ? trainTariffClass
            : [trainTariffClass];

        return TRAIN_TARIFF_CLASSES.filter(tariffClass =>
            queryClasses.includes(tariffClass),
        );
    },

    isAvailableForContext(context) {
        return (
            context.transportType === ALL_TYPE ||
            context.transportType === TRAIN_TYPE
        );
    },

    isAvailableWithOptions(options) {
        return options.length > 1;
    },

    validateValue(value = [], options = []) {
        return value.filter(item => options.includes(item));
    },
};
