/**
 * Проверяет соответсвует ли данный сегмент условиям фильтра
 * @param {number} segmentIndex
 * @param {{}} filtersData - состояние фильтров
 * @param {string} excludeFilterType - тип фильтра, который не нужно учитывать
 * @return {boolean}
 */
export default function applyFilters({
    segmentIndex,
    filtersData,
    excludeFilterType,
}) {
    return Object.keys(filtersData)
        .filter(filterType => filterType !== excludeFilterType)
        .every(
            filterType =>
                filtersData[filterType].filteredSegmentIndices[segmentIndex],
        );
}
