/**
 * Возвращает массив цен на билеты для сегмена
 * @param {Object} segment
 * @return {Array<{value: number, currency: (string|null), tariffName: string}>}
 */
export default function getSegmentPrices(segment) {
    const prices = [];

    if (!segment.tariffs || !segment.tariffs.classes) {
        return prices;
    }

    for (const [tariffName, tariffClass] of Object.entries(
        segment.tariffs.classes,
    )) {
        if (tariffClass.nationalPrice && tariffClass.nationalPrice.value) {
            prices.push({
                value: tariffClass.nationalPrice.value,
                currency: tariffClass.nationalPrice.currency || null,
                tariffName,
            });
        }
    }

    return prices;
}
