import fromPairs from 'lodash/fromPairs';

import getFilteredSegmentIndices from './getFilteredSegmentIndices';
import updateActiveOptions from './updateActiveOptions';

export default function updateFiltering({
    filtering,
    managers,
    newValues,
    segments,
}) {
    const managersDict = fromPairs(
        managers.map(manager => [manager.type, manager]),
    );
    const filtersData = Object.keys(newValues).reduce(
        (prevFiltersData, filterType) =>
            managersDict[filterType].setFilterValue({
                filtersData: prevFiltersData,
                value: newValues[filterType],
                segments,
            }),
        filtering.filters,
    );

    const updatedFiltersData = updateActiveOptions({
        managers,
        segments,
        filtersData,
    });

    return {
        filters: updatedFiltersData,
        filteredSegmentIndices: getFilteredSegmentIndices({
            filtersData: updatedFiltersData,
            segments,
        }),
    };
}
