/* eslint-disable quote-props */
const QUOTES = {
    '«': '»',
    '„': '“',
    '"': '"',
    "'": "'",
};

const QUOTES_PRIORITY = ['«', '„'];

export function split(str) {
    let result = [];
    let substr = '';
    let quote = false;
    let char = '';

    for (let i = 0; i < str.length; i++) {
        char = str.charAt(i);

        if (!quote && QUOTES[char]) {
            quote = char;

            if (substr) {
                result.push(substr);
                substr = '';
            }
        } else if (quote && char === QUOTES[quote]) {
            quote = false;
            result.push(split(substr));
            substr = '';
        } else {
            substr += char;
        }
    }

    if (quote) {
        result.push(quote);
    }

    if (substr) {
        if (quote) {
            result = result.concat(split(substr));
        } else {
            result.push(substr);
        }
    }

    return result;
}

export function build(splitted, priority) {
    return splitted
        .map(item => {
            if (typeof item === 'string') {
                return item;
            }

            const quote = QUOTES_PRIORITY[priority];

            return (
                quote +
                build(item, (priority + 1) % QUOTES_PRIORITY.length) +
                QUOTES[quote]
            );
        })
        .join('');
}

export function fixQuotes(str) {
    str = str.replace(/^\s*|\s*$/g, '');

    let splitted = split(str);

    if (splitted.length === 1 && typeof splitted[0] !== 'string') {
        splitted = splitted[0];
    }

    return build(splitted, 0);
}
