import formatBytes from '../formatBytes';

describe('formatBytes', () => {
    const tests: [number, string][] = [
        [10, '10B'],
        [100, '100B'],
        [1024, '1.0K'],
        [2000, '2.0K'],
        [20000, '20K'],
        [200000, '195K'],
        [2000000, '1.9M'],
        [20000000, '19M'],
        [200000000, '191M'],
        [2000000000, '1.9G'],
        [20000000000, '19G'],
        [200000000000, '186G'],
        [2000000000000, '1.8T'],
        [20000000000000, '18T'],
        [200000000000000, '182T'],
        [2000000000000000, '1819T'],
    ];

    tests.forEach(([from, to]) => {
        it(`${from} must be ${to}`, () => {
            expect(formatBytes(from)).toBe(to);
        });
    });
});
