export default function formatBytes(bytes: number): string {
    const BStr = `${bytes}B`;

    if (BStr.length <= 4) {
        return BStr;
    }

    const kB = bytes / 1024;
    const kBStr = format(kB, 'K');

    if (kBStr.length <= 4) {
        return kBStr;
    }

    const mB = kB / 1024;
    const mBStr = format(mB, 'M');

    if (mBStr.length <= 4) {
        return mBStr;
    }

    const gB = mB / 1024;
    const gBStr = format(gB, 'G');

    if (gBStr.length <= 4) {
        return gBStr;
    }

    const tB = gB / 1024;
    const tBStr = format(tB, 'T');

    return tBStr;
}

function format(number: number, letter: string): string {
    const digits = number < 10 ? 1 : 0;

    return `${number.toFixed(digits)}${letter}`;
}
