import formatInteger from './formatInteger';
import {getFormattedPrice} from './formatCurrency';

const ROUND_LIMIT = 100;

export default function formatFloat(
    {value, currency},
    round = value > ROUND_LIMIT,
) {
    const fixed = value.toFixed(round ? 0 : 2);

    let [whole, cents] = fixed.split('.');

    whole = formatInteger(whole);

    if (cents === '00') {
        cents = undefined;
    }

    return getFormattedPrice(currency, whole, cents);
}
