import formatInteger from './formatInteger';
import formatCurrency from './formatCurrency';

import priceKeyset from '../../i18n/price';

const ROUND_LIMIT = 100;

export default function formatPrice(
    {value, currency}: {value: number; currency: string},
    {from = false, round = value > ROUND_LIMIT},
): string {
    const fixed = value.toFixed(round ? 0 : 2);

    let [whole, cents] = fixed.split('.');

    whole = formatInteger(whole);

    if (cents === '00') {
        cents = '';
    }

    const price = formatCurrency(currency, whole, cents);

    if (from) {
        return priceKeyset('from', {price});
    }

    return price;
}

export function getSemanticPrice({value}, round = value > ROUND_LIMIT): string {
    return value.toFixed(round ? 0 : 2).replace('.00', '');
}
