/**
 * Проверяет, являются ли переданные коориднаты валидными
 * @param {Array} coord
 * @return {boolean}
 */
function checkIfValidCoordinates(coord) {
    return (
        coord &&
        coord.length === 2 &&
        !isNaN(parseFloat(coord[0])) &&
        !isNaN(parseFloat(coord[1]))
    );
}

/**
 * Принимает массив координат. Возвращает две координаты соответствующие нижнему правому
 * и верхнему левому углам прямоугольника, в который можно вписать все эти координаты
 * @param {Array[]} coords
 * @return {Array[]}
 */
export default function getMinMaxCoords(coords) {
    if (!Array.isArray(coords) || !coords.length) {
        return null;
    }

    const baseValue = [
        [Infinity, Infinity],
        [0, 0],
    ];

    const result = coords.reduce(
        (tempResult, coord) => {
            if (checkIfValidCoordinates(coord)) {
                tempResult[0] = [
                    Math.min(tempResult[0][0], coord[0]),
                    Math.min(tempResult[0][1], coord[1]),
                ];
                tempResult[1] = [
                    Math.max(tempResult[1][0], coord[0]),
                    Math.max(tempResult[1][1], coord[1]),
                ];
            }

            return tempResult;
        },
        [...baseValue],
    );

    // Если все значения массива оказались некорректными, возвращаем null
    return result[0] === baseValue[0] && result[1] === baseValue[1]
        ? null
        : result;
}
