import {TransportType} from './transportType';

import keyset from '../i18n/transport-types';

// Аналог getTransportTypeName, но не использует динамические ключи в кейсетах,
// чтобы в будущем неиспользуемые ключи можно было резать вебпаком на этапе threeShaking
// чтобы они не попадали в сборку
export default function getStaticTransportTypeName(
    transportType: TransportType,
): string {
    switch (transportType) {
        case TransportType.bus:
            return keyset('type-bus');
        case TransportType.plane:
            return keyset('type-plane');
        case TransportType.suburban:
            return keyset('type-suburban');
        case TransportType.train:
            return keyset('type-train');
        case TransportType.water:
            return keyset('type-water');
    }
}
