import IBreadcrumb from '../../interfaces/IBreadcrumb';
import IParentChildStaticPage from '../../interfaces/state/info/IParentChildStaticPage';
import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';

import getMainPage from '../url/crumble/getMainPage';
import getInfoUrl from '../url/getInfoUrl';

interface IGetInfoBreadCrumbs {
    title: string;
    parents: IParentChildStaticPage[];
    tld: Tld;
    language: Lang;
}

export default function getInfoBreadCrumbs({
    title,
    parents,
    tld,
    language,
}: IGetInfoBreadCrumbs): IBreadcrumb[] {
    const parentCrumbs = parents.map(
        ({slug: parentSlug, id: parentId, title: parentTitle}) => ({
            name: parentTitle,
            url: getInfoUrl(parentSlug || parentId, tld, language),
        }),
    );

    return [getMainPage('/'), ...parentCrumbs, {name: title}];
}
