import {MODERN_VERSIONS} from '../../webpack/supportedBrowsers';

import IStateUserBrowser from '../interfaces/state/user/IStateUserBrowser';

const modernVersions = Object.entries(MODERN_VERSIONS).reduce(
    (obj, [key, value]) => {
        const browserName = key.toLowerCase();

        obj[browserName] = value;

        switch (browserName) {
            case 'firefoxmobile':
                obj.mobilefirefox = value;
                break;
            case 'safarimobile':
                obj.mobilesafari = value;
                break;
            case 'samsung':
                obj['samsung internet'] = value;
                break;
        }

        return obj;
    },
    {} as Record<string, number>,
);

function getName(browser: IStateUserBrowser): string {
    if (browser.name === 'YandexSearch' && browser.base === 'Chromium') {
        return 'chromemobile';
    }

    return (browser.name || '').toLowerCase();
}

function getVersion(browser: IStateUserBrowser): number {
    if (
        browser.name === 'YandexSearch' &&
        browser.base === 'Chromium' &&
        browser.baseVersion
    ) {
        return parseInt(browser.baseVersion, 10);
    }

    return browser.version ? parseInt(browser.version, 10) : NaN;
}

export default function isModernBrowser(browser: IStateUserBrowser): boolean {
    const name = getName(browser);
    const version = getVersion(browser);

    const minVersionInModernBrowsers = modernVersions[name];

    if (minVersionInModernBrowsers === undefined) {
        return false;
    }

    return version >= minVersionInModernBrowsers;
}
