import {YBUS} from './segments/tariffSources';

/**
 * Метод преобразует данные из stor'а для логирования по Я.Автобусам
 * @param {Object[]} segments - массив сегментов
 * @return {Object}
 */
export function prepareBusTariffsData({segments = []}) {
    const busSegments = segments.filter(({source}) => source === YBUS);
    const ambiguousSegments = segments.filter(
        ({missedTariffs}) => missedTariffs && missedTariffs.length,
    );
    const ambiguousKeys = ambiguousSegments.reduce(
        (keys, {missedTariffs}) => [...keys, ...missedTariffs],
        [],
    );
    const ambiguous = ambiguousKeys.map(yBusId => ({
        yBusId,
        threadUids: ambiguousSegments
            .filter(({missedTariffs}) => missedTariffs.includes(yBusId))
            .map(({thread}) => thread && thread.uid),
    }));

    if (!busSegments.length && !ambiguous.length) {
        return null;
    }

    const addition = busSegments
        .filter(({isDynamic}) => isDynamic)
        .map(({yBusId}) => yBusId);

    return {
        addition,
        ambiguous,
        merged: busSegments.length - addition.length,
        stationsAreDifferent: busSegments
            .filter(({stationsAreDifferent}) => Boolean(stationsAreDifferent))
            .map(({yBusId}) => yBusId),
    };
}
