export const noIndex = {content: 'noindex, nofollow', name: 'robots'};

/**
 * Добавляет в мета-описание страницы инофрмацию о том, что ее не нужно индексировать.
 * Метод мутирует исходный объект.
 * @param {Array} meta
 * @return {Array}
 */
export default function addNoIndexPageToMeta(meta) {
    if (
        !meta.find(
            value =>
                value.content === noIndex.content &&
                value.name === noIndex.name,
        )
    ) {
        meta.push(noIndex);
    }

    return meta;
}
