import {encodeSpecialCharacters} from '../stringUtils';

const TAG_NAMES = {
    HTML: 'htmlAttributes',
    TITLE: 'title',
    BASE: 'base',
    META: 'meta',
    LINK: 'link',
    SCRIPT: 'script',
    STYLE: 'style',
};

/**
 * Простая функция генерации HTML тэга в строку
 * Выдрана из исходников пакета Helmet и оставлена жить так
 * Используется в server/template.js
 * @param {string} type - тип тэга для генерации (link, meta, script, etc.)
 * @param {Object[]} tags - массив данных для генерации
 * @return {string}
 */
export default function generateTagsAsString(type, tags) {
    const stringifiedMarkup = tags
        .map(tag => {
            const attributeHtml = Object.keys(tag)
                .filter(
                    attribute =>
                        !(attribute === 'innerHTML' || attribute === 'cssText'),
                )
                .map(attribute => {
                    if (typeof tag[attribute] === 'undefined') {
                        return attribute;
                    }

                    const encodedValue = encodeSpecialCharacters(
                        tag[attribute],
                    );

                    return `${attribute}="${encodedValue}"`;
                })
                .join(' ')
                .trim();

            const tagContent = tag.innerHTML || tag.cssText || '';

            return `<${type} ${attributeHtml}${
                type === TAG_NAMES.SCRIPT || type === TAG_NAMES.STYLE
                    ? `>${tagContent}</${type}>`
                    : '/>'
            }`;
        })
        .join('');

    return stringifiedMarkup;
}
