import {momentTimezone as moment} from '../../../reexports';

import {FilterTransportType} from '../transportType';
import ISearchContext from '../../interfaces/state/search/ISearchContext';

interface INewPlanDescriptionDate {
    showNewPlanDescription: boolean;
    newPlanDate: moment.Moment;
}

// Решает, нужно ли показывать описание с текстом про новый план и определяет дату его начала
export default function getNewPlanDescriptionData(
    context: ISearchContext,
): INewPlanDescriptionDate {
    const {time, when, transportType} = context;
    const {date} = when;
    const {now} = time;

    const currentDate = moment(now);
    const startShowingDate = moment({M: 9, d: 1, y: currentDate.year()});
    // Дата вступления в действие нового плана - второе воскресенье декабря
    const newPlanDate = moment({M: 11, d: 1, y: currentDate.year()}).day(14);
    const requestedDate = moment(date);

    const showNewPlanDescription =
        (transportType === FilterTransportType.suburban ||
            transportType === FilterTransportType.all) &&
        startShowingDate.isBefore(currentDate) &&
        currentDate.isBefore(newPlanDate) &&
        newPlanDate.isBefore(requestedDate);

    return {showNewPlanDescription, newPlanDate};
}
