import IStateSearchForm from '../../../common/interfaces/state/IStateSearchForm';
import SearchFormErrorField from '../../../common/interfaces/state/searchForm/SearchFormErrorField';
import SearchFormErrorDateType from '../../../common/interfaces/state/searchForm/SearchFormErrorDateType';
import SearchErrorPageType from '../../../common/interfaces/components/searchErrorPage/SearchErrorPageType';
import SearchFormErrorPointsType from '../../../common/interfaces/state/searchForm/SearchFormErrorPointsType';

import getSearchErrorField from './getSearchErrorField';

import keyset from '../../i18n/error-page-search-form';

interface ISearchFormErrorInfo {
    title: string;
    subtitle?: string;
    errorType: SearchErrorPageType;
}

export default function getSearchFormErrorInfo(
    searchForm: IStateSearchForm,
): ISearchFormErrorInfo | null {
    const {errors = []} = searchForm;

    const errorTypeOfFromField:
        | SearchFormErrorPointsType
        | SearchFormErrorDateType
        | undefined = errors.find(
        error => getSearchErrorField(error) === SearchFormErrorField.FROM,
    )?.type;
    const errorTypeOfToField:
        | SearchFormErrorPointsType
        | SearchFormErrorDateType
        | undefined = errors.find(
        error => getSearchErrorField(error) === SearchFormErrorField.TO,
    )?.type;

    if (
        errorTypeOfFromField === errorTypeOfToField &&
        (errorTypeOfFromField === SearchFormErrorPointsType.POINT_NOT_FOUND ||
            errorTypeOfFromField ===
                SearchFormErrorPointsType.SETTLEMENT_NOT_FOUND ||
            errorTypeOfFromField ===
                SearchFormErrorPointsType.STATION_NOT_FOUND)
    ) {
        return {
            title: keyset('error-points_not_found'),
            subtitle: keyset('error-points_not_found-subtitle'),
            errorType: SearchErrorPageType.noTickets,
        };
    }

    const firstError = errors[0];
    const field = getSearchErrorField(errors[0]);

    if (field === SearchFormErrorField.WHEN) {
        return {
            title: keyset('error-when-incorrect'),
            errorType: SearchErrorPageType.reload,
        };
    }

    if (field === SearchFormErrorField.TO) {
        switch (firstError.type) {
            case SearchFormErrorPointsType.EMPTY:
                return {
                    title: keyset('error-to-empty'),
                    errorType: SearchErrorPageType.reload,
                };
            case SearchFormErrorPointsType.POINT_NOT_FOUND:
                return {
                    title: keyset('error-to-point_not_found'),
                    subtitle: keyset('error-point_not_found-subtitle'),
                    errorType: SearchErrorPageType.noTickets,
                };
            case SearchFormErrorPointsType.SAME:
                return {
                    title: keyset('error-to-same'),
                    errorType: SearchErrorPageType.reload,
                };
            case SearchFormErrorPointsType.SAME_POINTS:
                return {
                    title: keyset('error-to-same_points'),
                    errorType: SearchErrorPageType.reload,
                };
            case SearchFormErrorPointsType.SETTLEMENT_NOT_FOUND:
                return {
                    title: keyset('error-to-settlement_not_found'),
                    subtitle: keyset('error-point_not_found-subtitle'),
                    errorType: SearchErrorPageType.noTickets,
                };
            case SearchFormErrorPointsType.STATION_NOT_FOUND:
                return {
                    title: keyset('error-to-station_not_found'),
                    subtitle: keyset('error-point_not_found-subtitle'),
                    errorType: SearchErrorPageType.noTickets,
                };
            case SearchFormErrorPointsType.TOO_GENERAL:
                return {
                    title: keyset('error-to-too_general'),
                    errorType: SearchErrorPageType.reload,
                };
            case SearchFormErrorPointsType.TOO_SHORT:
                return {
                    title: keyset('error-to-too_short'),
                    errorType: SearchErrorPageType.reload,
                };
        }
    }

    if (field === SearchFormErrorField.FROM) {
        switch (firstError.type) {
            case SearchFormErrorPointsType.EMPTY:
                return {
                    title: keyset('error-from-empty'),
                    errorType: SearchErrorPageType.reload,
                };
            case SearchFormErrorPointsType.POINT_NOT_FOUND:
                return {
                    title: keyset('error-from-point_not_found'),
                    subtitle: keyset('error-point_not_found-subtitle'),
                    errorType: SearchErrorPageType.noTickets,
                };
            case SearchFormErrorPointsType.SAME:
                return {
                    title: keyset('error-from-same'),
                    errorType: SearchErrorPageType.reload,
                };
            case SearchFormErrorPointsType.SAME_POINTS:
                return {
                    title: keyset('error-from-same_points'),
                    errorType: SearchErrorPageType.reload,
                };
            case SearchFormErrorPointsType.SETTLEMENT_NOT_FOUND:
                return {
                    title: keyset('error-from-settlement_not_found'),
                    subtitle: keyset('error-point_not_found-subtitle'),
                    errorType: SearchErrorPageType.noTickets,
                };
            case SearchFormErrorPointsType.STATION_NOT_FOUND:
                return {
                    title: keyset('error-from-station_not_found'),
                    subtitle: keyset('error-point_not_found-subtitle'),
                    errorType: SearchErrorPageType.noTickets,
                };
            case SearchFormErrorPointsType.TOO_GENERAL:
                return {
                    title: keyset('error-from-too_general'),
                    errorType: SearchErrorPageType.reload,
                };
            case SearchFormErrorPointsType.TOO_SHORT:
                return {
                    title: keyset('error-from-too_short'),
                    errorType: SearchErrorPageType.reload,
                };
        }
    }

    return null;
}
