import {HelmetProps} from 'react-helmet';

import IState from '../../../interfaces/state/IState';

import defaultMetaInformation from './default';
import addNoIndexPageToMeta from '../addNoIndexPageToMeta';
import getBaseMeta from './getBaseMeta';

import keysetMetaAmbiguous from '../../../i18n/meta-ambiguous';
import keysetMetaDefault from '../../../i18n/meta-default';
import pageKeyset from '../../../i18n/page';

export default function ambiguous(state: IState): HelmetProps {
    const {tld} = state;
    const defaultMeta = defaultMetaInformation(state);

    addNoIndexPageToMeta(defaultMeta.meta);

    const meta = getBaseMeta(
        pageKeyset('title-index'),
        pageKeyset('description-home'),
        `https://rasp.yandex.${tld}/`,
    );

    return {
        ...defaultMeta,
        title: keysetMetaDefault('title-with-service-name', {
            title: keysetMetaAmbiguous('title'),
        }),
        meta,
    };
}
