import {VIEWPORT} from './constants';

import keyset from '../../../i18n/meta-default';

export default function defaultMetaInformation(state) {
    const {language, tld} = state;

    return {
        htmlAttributes: {
            lang: language,
        },
        title: keyset('default-title'),
        meta: [
            {charset: 'utf-8'},
            {name: 'description', content: keyset('description')},
            {property: 'og:title', content: keyset('og:title')},
            {property: 'og:description', content: keyset('og:description')},
            {name: 'viewport', content: VIEWPORT},
            {property: 'og:type', content: 'website'},
            {property: 'og:site_name', content: keyset('og:site_name')},
            {property: 'og:url', content: `http://rasp.yandex.${tld}`},
        ],
    };
}

/**
 * Метод вернет переданный заголовок страницы с подставленным названием сервиса
 * Приммерный шаблон: {title} - Яндекс Расписания
 * @param {string} title
 * @return {string}
 */
export function serviceNameTitle(title) {
    return keyset('title-with-service-name', {title});
}
