import {IMetaProps} from '../../../interfaces/meta/IMetaProps';

import {VIEWPORT} from './constants';

import keyset from '../../../i18n/meta-default';

export default function getBaseMeta(
    title: string,
    description: string,
    canonicalUrl: string,

    ogDescription?: string,
): IMetaProps[] {
    return [
        {charset: 'utf-8'},
        {name: 'description', content: description},
        {property: 'og:title', content: title},
        {property: 'og:description', content: ogDescription || description},
        {name: 'viewport', content: VIEWPORT},
        {property: 'og:type', content: 'website'},
        {property: 'og:site_name', content: keyset('og:site_name')},
        {property: 'og:url', content: canonicalUrl},
    ];
}
