import {HelmetProps} from 'react-helmet';

import IState from '../../../interfaces/state/IState';
import Platform from '../../../interfaces/Platform';

import defaultMetaInformation from './default';
import getInfoUrl from '../../url/getInfoUrl';
import getDesktopUrl from '../../url/getDesktopUrl';
import {
    getTouchAlternateLink,
    getAlternateLanguageLinks,
} from '../../url/altLinks';
import getBaseMeta from './getBaseMeta';

export default function infoMeta(state: IState): HelmetProps {
    const {info, page, tld, language, platform} = state;

    const {slug, id, metaTitle, metaDescription} = info;

    const canonicalPath = getInfoUrl(slug || id, tld, language);
    const canonicalUrl = getDesktopUrl(page.originUrl) + canonicalPath;

    const meta = getBaseMeta(metaTitle, metaDescription, canonicalUrl);

    const link = [{rel: 'canonical', href: canonicalUrl}];

    if (platform !== Platform.mobile) {
        link.push(getTouchAlternateLink(canonicalUrl));
    }

    link.push(
        ...getAlternateLanguageLinks({page, path: canonicalPath, platform}),
    );

    return {
        ...defaultMetaInformation(state),
        title: metaTitle,
        meta,
        link,
    };
}
