import Platform from '../../../interfaces/Platform';
import {FilterTransportType} from '../../transportType';

import defaultMetaInformation from './default';
import getThreadUrl from '../../url/getThreadUrl';
import getDesktopUrl from '../../url/getDesktopUrl';
import {
    getTouchAlternateLink,
    getAlternateLanguageLinks,
} from '../../url/altLinks';
import getBaseMeta from './getBaseMeta';

import metaKeyset from '../../../i18n/meta-thread';

export default function threadMeta(state) {
    const {thread, page, tld, language, platform} = state;
    const {
        title: threadTitle,
        shortTitle,
        number,
        id,
        canonicalUid,
        transportType,
        deluxeTrain,
    } = thread;
    const isTrain = transportType === FilterTransportType.train;
    const deluxeTrainTitle =
        isTrain && deluxeTrain?.title
            ? metaKeyset('title-train-deluxe', {
                  number,
                  title: deluxeTrain.title,
                  departureAndArrival: shortTitle,
              })
            : null;
    const title =
        deluxeTrainTitle ||
        (isTrain
            ? metaKeyset('title-train-2', {title: shortTitle, number})
            : threadTitle);
    const descriptionKey = `description${isTrain ? '-train' : ''}`;
    const description = metaKeyset(descriptionKey, {title: threadTitle});

    const canonicalPath = getThreadUrl({
        threadUid: id,
        canonicalUid,
        tld,
        language,
    });
    const canonicalUrl = getDesktopUrl(page.originUrl) + canonicalPath;

    const meta = getBaseMeta(title, description, canonicalUrl);

    const link = [{rel: 'canonical', href: canonicalUrl}];

    if (platform !== Platform.mobile) {
        link.push(getTouchAlternateLink(canonicalUrl));
    }

    link.push(
        ...getAlternateLanguageLinks({page, path: canonicalPath, platform}),
    );

    return {
        ...defaultMetaInformation(state),
        title,
        meta,
        link,
    };
}
