import ALTERNATE_LANGUAGE_DOMAINS from '../../url/alternateLanguageDomains';

import Platform from '../../../interfaces/Platform';

import defaultMetaInformation from './default';
import buildTransportUrl from '../../url/transportUrl';
import getDesktopUrl from '../../url/getDesktopUrl';
import {
    getTouchAlternateLink,
    getAlternateLanguageLinks,
} from '../../url/altLinks';
import getBaseMeta from './getBaseMeta';

import metaKeyset from '../../../i18n/meta-transport';

export default function transportMeta(state) {
    const {tld, page, transport, platform} = state;

    const {countries, transportType} = transport;
    // Список доменов, в которых доступна страница для данного вида транспорта
    const availableDomains = countries.map(({code}) => code.toLowerCase());
    const {titlePrepositional} = countries.find(
        country => country.code.toLowerCase() === tld,
    );
    const title = metaKeyset(`title-${transportType}`, {titlePrepositional});
    const description = metaKeyset(`description-${transportType}`, {
        titlePrepositional,
    });

    const canonicalPath = buildTransportUrl({transportType});
    const canonicalUrl = getDesktopUrl(page.originUrl) + canonicalPath;

    const meta = getBaseMeta(title, description, canonicalUrl);

    const link = [{rel: 'canonical', href: canonicalUrl}];

    if (platform !== Platform.mobile) {
        link.push(getTouchAlternateLink(canonicalUrl));
    }

    link.push(
        ...getAlternateLanguageLinks({
            page,
            path: canonicalPath,
            platform,
            languageDomains: ALTERNATE_LANGUAGE_DOMAINS.filter(({host}) => {
                const domain = host.split('.').pop().toLowerCase();

                return availableDomains.includes(domain);
            }),
        }),
    );

    return {
        ...defaultMetaInformation(state),
        title,
        meta,
        link,
    };
}
