import Platform from '../../../interfaces/Platform';

import defaultMetaInformation from './default';
import getDesktopUrl from '../../url/getDesktopUrl';
import getTransportCityUrl from '../../url/transportCityUrl';
import {
    getTouchAlternateLink,
    getAlternateLanguageLinks,
} from '../../url/altLinks';
import getBaseMeta from './getBaseMeta';

import metaKeyset from '../../../i18n/meta-transport-city';

export default function transportCityMeta(state) {
    const {transportCity, page, platform} = state;
    const {
        transportType,
        settlement: {title: settlementTitle, slug},
    } = transportCity;
    const title = metaKeyset(`title-${transportType}`, {settlementTitle});
    const description = metaKeyset(`description-${transportType}`, {
        settlementTitle,
    });

    const canonicalPath = getTransportCityUrl({slug, transportType});
    const canonicalUrl = getDesktopUrl(page.originUrl) + canonicalPath;

    const meta = getBaseMeta(title, description, canonicalUrl);

    const link = [{rel: 'canonical', href: canonicalUrl}];

    if (platform !== Platform.mobile) {
        link.push(getTouchAlternateLink(canonicalUrl));
    }

    link.push(
        ...getAlternateLanguageLinks({page, path: canonicalPath, platform}),
    );

    return {
        ...defaultMetaInformation(state),
        title,
        meta,
        link,
    };
}
