import {HOME_PAGE_NAME} from '../../routes';
import {SEARCH} from '../../routes/search';
import {ERROR_TYPES} from '../errors/errorTypes';
import {THREAD_PAGE_NAME} from '../../routes/thread';
import {TRANSPORT_CITY_PAGE_NAME} from '../../routes/transportCity';
import {TRANSPORT_PAGE_NAME} from '../../routes/transport';
import {STATION_PAGE_NAME} from '../../routes/station';
import {INFO_PAGE_NAME} from '../../routes/info';

import defaultMetaInformation from './metaPages/default';
import searchMeta from './metaPages/search';
import thread from './metaPages/thread';
import transportCity from './metaPages/transportCity';
import transport from './metaPages/transport';
import station from './metaPages/station';
import ambiguous from './metaPages/ambiguous';
import errorSearchForm from './metaPages/errorSearchForm';
import homeMeta from './metaPages/home';
import info from './metaPages/info';

export default function metaTags(state) {
    const {page} = state;
    const currentPage = page.current;

    switch (currentPage) {
        case HOME_PAGE_NAME:
            return homeMeta(state);
        case SEARCH:
            return searchMeta(state);
        case ERROR_TYPES.AMBIGUOUS:
            return ambiguous(state);
        case ERROR_TYPES.SEARCH_FORM:
            return errorSearchForm(state);
        case THREAD_PAGE_NAME:
            return thread(state);
        case TRANSPORT_CITY_PAGE_NAME:
            return transportCity(state);
        case TRANSPORT_PAGE_NAME:
            return transport(state);
        case STATION_PAGE_NAME:
            return station(state);
        case INFO_PAGE_NAME:
            return info(state);

        default:
            return defaultMetaInformation(state);
    }
}
