import {reachGoal} from '../yaMetrika';
import {PLANE_TYPE, BUS_TYPE, TRAIN_TYPE} from '../transportType';
import {YBUS} from '../segments/tariffSources';

import {makeCacheable} from '../cache';

export const createOrderGoalHandler = makeCacheable(
    (
            transportType,
            source,
            isUFSLink,
            badges,
            pageType,
            isTransfer,
            isTransferSegment,
        ) =>
        () => {
            reachGoal(
                `order_${transportType}_click${pageType ? `_${pageType}` : ''}`,
            );

            if (transportType === PLANE_TYPE) {
                reachGoal('redirect_to_partner');
            }

            if (transportType === BUS_TYPE && source === YBUS) {
                reachGoal('order_ybus_click');
                reachGoal('redirect_to_partner');
            }

            if (transportType === TRAIN_TYPE && isUFSLink) {
                reachGoal('order_ufs_link_click');
            }

            if (badges) {
                Object.keys(badges).forEach(badge => {
                    reachGoal(`click_on_${badge}_badges_train`);
                });
            }

            if (isTransfer) {
                reachGoal('transfersWithPrices_clickBuyButtonInterline');
            }

            if (isTransferSegment) {
                reachGoal('transfersWithPrices_clickBuyButtonTransferSegment');
            }
        },
);

export const addOrderGoalHandler = makeCacheable(
    (
        handler,
        transportType,
        source,
        isUFSLink,
        badges,
        pageType,
        isTransfer,
        isTransferSegment,
    ) => {
        const reachOrderGoal = createOrderGoalHandler(
            transportType,
            source,
            isUFSLink,
            badges,
            pageType,
            isTransfer,
            isTransferSegment,
        );

        return e => {
            handler(e);
            reachOrderGoal();
        };
    },
);
