import {reachGoalOnce} from '../yaMetrika';

const SCALE_STEP = 5;

export default function reachGoalSegmentsRatio(
    segments,
    {originUrl, location},
    {from, to, when},
) {
    const dynamicSegments = segments.filter(({isDynamic}) => isDynamic);
    const ratio = (100 * dynamicSegments.length) / segments.length;
    const roundedRatio = isNaN(ratio)
        ? 0
        : Math.ceil(ratio / SCALE_STEP) * SCALE_STEP;

    if (roundedRatio > 5) {
        reachGoalOnce('high-segments-ratio');
    }

    reachGoalOnce('segments-ratio', {
        'segments-ratio': {
            [roundedRatio]: `${originUrl}${location.pathname}?fromId=${from.key}&toId=${to.key}&when=${when.date}`,
        },
    });
}
